//////////////////////////////////////////////
// Logger.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.LogManager = class LogManager extends nkDebug.TestClass
{
	static instance = new LogManager ("nkGraphicsTests.LogManager") ;

	nkTests =
	{
		__testShutdown__ : function ()
		{
			nkGraphics.System.getInstance().shutdown()  ;
			nkGraphics.System.kill() ;
		},

		RegisterLogger : function ()
		{
			// Witness of call
			var called = false ;

			// Create a class inheriting from it
			class TestLogger extends nkLog.Logger
			{
				log (m, c)
				{
					called = true ;
				}
			} ;

			// Register
			const l = new TestLogger () ;
			nkGraphics.LogManager.getInstance().setReceiver(l) ;
			nkGraphics.System.getInstance().initialize()
			nkDebug.TestUtils.check(called) ;

			// Free (unmanaged extension)
			nkGraphics.LogManager.getInstance().setReceiver(null) ;
			l.delete() ;
		}
	}
}